/*
 ---------------- MSP430 LaunchPad + ENC28j60 Ethernet Controller ------------------------------------------
 -
 - Eredeti forrskd (Arduino):
 -                        http://trollmaker.com/article11/arduino-1-0-with-enc28j60-ethernet-shield-v1-1
 - trva MSP430g2553-ra! IAR Embedded Workbench for MSP430 IDE v5.50.2
 -                        Ksztette: Szitkovits Gbor
 ------------------------------------------------ MSP430g2553 -------------------------------------------- */

#include <msp430.h>
#include <string.h>
#include <stdint.h>
#include "web.h"
#include "enc28j60.h"
#include "ip_arp_udp_tcp.h"
#include "net.h"

#define BUFFER_SIZE 350
#define STR_BUFFER_SIZE 32
#define ALPHANUMS "zyxwvutsrqponmlkjihgfedcba9876543210123456789abcdefghijklmnopqrstuvwxyz"

uint8_t buf[BUFFER_SIZE+1];
char strbuf[STR_BUFFER_SIZE+1];
uint16_t plen;

void Web_setup(){
     
     enc28j60clkout(2); // change clkout from 6.25MHz to 12.5MHz
     delay_ms(10);
     enc28j60PhyWrite(PHLCON,0x880);
     delay_ms(500);
     enc28j60PhyWrite(PHLCON,0x990);
     delay_ms(500);
     enc28j60PhyWrite(PHLCON,0x880);
     delay_ms(500);
     enc28j60PhyWrite(PHLCON,0x990);
     delay_ms(500);
     enc28j60PhyWrite(PHLCON,0x476);
     delay_ms(100);
}

char* Web_serviceRequest(uint16_t port){
     
     uint16_t dat_p;
     plen = enc28j60PacketReceive(BUFFER_SIZE, buf);
     
     /*plen will ne unequal to zero if there is a valid packet (without crc error) */
     if(plen!=0){
          // arp is broadcast if unknown but a host may also verify the mac address by sending it to a unicast address.
          if (eth_type_is_arp_and_my_ip(buf, plen)){
               make_arp_answer_from_request(buf);
               return 0;
          }
          // check if ip packets are for us:
          if (eth_type_is_ip_and_my_ip(buf, plen) == 0){
               return 0;
          }
          if (buf[IP_PROTO_P]==IP_PROTO_ICMP_V && buf[ICMP_TYPE_P]==ICMP_TYPE_ECHOREQUEST_V){
               make_echo_reply_from_request(buf, plen);
               return 0;
          }
          // tcp port www start, compare only the lower byte
          if (buf[IP_PROTO_P]==IP_PROTO_TCP_V&&buf[TCP_DST_PORT_H_P]==0&&buf[TCP_DST_PORT_L_P] == port){
               if (buf[TCP_FLAGS_P] & TCP_FLAGS_SYN_V){
                    make_tcp_synack_from_syn(buf); // make_tcp_synack_from_syn does already send the syn,ack
                    return 0;
               }
               if (buf[TCP_FLAGS_P] & TCP_FLAGS_ACK_V){
                    init_len_info(buf); // init some data structures
                    dat_p = get_tcp_data_pointer();
                    if (dat_p==0){ // we can possibly have no data, just ack:
                         if (buf[TCP_FLAGS_P] & TCP_FLAGS_FIN_V){
                              make_tcp_ack_from_any(buf);
                         }
                         return 0;
                    }
                    if (strncmp("GET ",(char *)&(buf[dat_p]),4)!=0){
                         // head, post and other methods for possible status codes see:
                         // http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html
                         plen = fill_tcp_data_p(buf,0,"HTTP/1.0 200 OK\r\nContent-Type: text/html\r\n\r\n<h1>200 OK</h1>");
                         plen = fill_tcp_data_p(buf,plen,"<h1>A</h1>");
                         Web_respond();
                    }
                    if (strncmp("/",(char *)&(buf[dat_p+4]),1)==0){ // was "/ " and 2
                         // Copy the request action before we overwrite it with the response
                         int i = 0;
                         while (buf[dat_p+5+i] != ' ' && i < STR_BUFFER_SIZE){
                              strbuf[i] = buf[dat_p+5+i];
                              i++;
                         }
                         strbuf[i] = '\0';
                         plen = fill_tcp_data_p(buf,0,"HTTP/1.0 200 OK\r\nContent-Type: text/html\r\n\r\n");
                         return (char*)strbuf;
                    }
               }
          }
     }
}

void Web_print(char* text){
     
     int j = 0;
     while (text[j]){
          buf[TCP_CHECKSUM_L_P+3+plen]=text[j++];
          plen++;
     } //while
}
void Web_print_num(int number){
     char tempString[9]; 
     itoa(number, tempString, 10);
     Web_print(tempString);
}
void Web_respond(){
     make_tcp_ack_from_any(buf); // send ack for http get
     make_tcp_ack_with_data(buf,plen); // send data
}
int itoa(int number, char* out, int base){
     int t, count;
     char *p, *q;
     char c;
 
     p = q = out;
     if (base < 2 || base > 36) base = 10;
 
     do {
         t = number;
         number /= base;
         if (out) *p = ALPHANUMS[t+35 - number*base];
         p++;
     } while (number);
 
     if (t < 0) {
          if (out) *p = '-';
          p++;
     }
     count = p-out;
     if (out) {
         *p-- = '\0';
         while(q < p) {
             c = *p;
             *p-- = *q;
             *q++ = c;
         }
     }
     return count;
}
void delay_ms(uint16_t t){
     uint16_t i;
     for(i=0; i<t; i++){
          __delay_cycles(8000);
     } // for ciklus
} // void delay_ms
